﻿var sfIntegrationDetails =
{
    sfInstanceTypeId: "0",
    sfInstanceUrl: "",
    sfLoginWindow: null
}

function handleDisconnect() {
    var dialogContent = {
        Title: resources.SF_Integration_Disconnect_Confirmation_Title, Message: resources.SF_Integration_Disconnect_Confirmation_Body, ConfirmButton: resources.Confirm
    };
    modalDialog.showConfirmDialog(dialogContent, function () {
        var params = {};
        var url = a4.getAction("DisConnectIntegration", "Integrations", "Settings");

        a4.callServerMethod(url, params, function (response) {
            if (response != undefined && response != null) {

                // Disable the "DisConnect" button
                a4.parent().$("#btnSfDisConnect").prop("disabled", true);

                // Change text for "Connect" button
                $("#btnSfConnect").val(resources.Connect);

                a4.showSuccessMessage(resources.SF_Integration_Disconnected_Successfully);
            }
        }, function (response) {
            a4.showErrorMessage(errorResources.SF_Integration_Error_Disconnecting_Integration);
        });
    });
}

function checkforInitialConnectivityToSalesforce() {
    var params = {};
    var url = a4.getAction("CheckforSfConnectivity", "Integrations", "Settings");

    a4.callServerMethod(url, params, function (response) {
        if (response != undefined && response != null) {
            let integrationInfo = response['integrationInfo'];
            raiseLoginPopupForSfIntegration(integrationInfo);
        }
    }, function (response) {
        a4.showErrorMessage(errorResources.SF_Integration_Connectivity_Error);
    });
}

function raiseLoginPopupForSfIntegration(integrationInfo) {    
    let isConnected = integrationInfo.Status === 2;
    let params = { isConnected: isConnected, instanceType: getInstanceType(integrationInfo.SFInstanceType), instanceUrl: integrationInfo.SFInstanceUrl, createdOn: integrationInfo.CreatedOn.toString() };

    var height = 400; var width = 800;
    modalDialog.showWindow(a4.getAction("SFCustomIntegrationLogin", "Integrations", "Settings", params), height, width, {
        afterClose: function () {
        }
    });
}

function initiateSfIntegration() {
    var params = {
        sfInstanceTypeId: sfIntegrationDetails.sfInstanceTypeId
    };
    var url = a4.getAction("InitiateCustomSfIntegration", "Integrations", "Settings");

    a4.callServerMethod(url, params, function (response) {
        if (response != undefined && response != null) {
            let windowParams = `width=500, height=600, location=1, status=1, left=-1000, top=-1000`;
            let newWindow = window.open("", "anotherWindow", windowParams);
            sfIntegrationDetails.sfLoginWindow = newWindow;
            newWindow.document.write(response['htmlResponse']);
            newWindow.focus();
        }
    }, function (response) {
        a4.showErrorMessage(errorResources.SF_Integration_Integration_Error);
    });
}

function checkForIntegrationStatusAfterProcessStarted() {
    var qnsTableCheckInterval;
    qnsTableCheckInterval = setInterval(function () {
        var params = {};
        var url = a4.getAction("CheckforSfConnectivity", "Integrations", "Settings");

        a4.callServerMethod(url, params, function (response) {
            if (response != undefined && response != null) {
                let integrationInfo = response['integrationInfo'];
                if (integrationInfo.Status === 2) {
                    clearInterval(qnsTableCheckInterval);

                    // Disable "Account details" and Enable "Display Details"
                    $('.sf-accountType-selection-div', '.sf-custom-integration').hide();
                    $('.sf-accountDetails-display-div', '.sf-custom-integration').show();

                    // Disbale 'Connect' button in the popup
                    $('#btnSfConnectNext').css("display", "none");

                    // Enable the "DisConnect" button
                    a4.parent().$("#btnSfDisConnect").prop("disabled", false);

                    if (sfIntegrationDetails.sfLoginWindow !== null) {
                        sfIntegrationDetails.sfLoginWindow.close();
                    }
                    a4.showSuccessMessage(resources.SF_Integration_Connection_Successful);
                    displayConnectivityDetails(integrationInfo);
                }
                else if (integrationInfo.Status === -1) {
                    clearInterval(qnsTableCheckInterval);

                    // Enable 'Connect' button in the popup
                    $('#btnSfConnectNext').prop("disabled", false);

                    if (sfIntegrationDetails.sfLoginWindow !== null) {
                        sfIntegrationDetails.sfLoginWindow.close();
                    }

                    a4.showErrorMessage(errorResources.SF_Integration_Connectivity_Error);
                    resetStatusToDisconnect();
                }
            }
        }, function (response) {
            a4.showErrorMessage(resources.SF_Integration_Connectivity_Error)
        });
    }, 2000);
}

function displayConnectivityDetails(integrationInfo) {

    $('label', $('.instanceType', '.account-details-table')).text(getInstanceType(integrationInfo.SFInstanceType));
    $('label', $('.instanceUrl', '.account-details-table')).text(integrationInfo.SFInstanceUrl);
    $('label', $('.createdOn', '.account-details-table')).text(integrationInfo.CreatedOn.toString());
    $('.sf-accountDetails', '.sf-custom-integration').show();

    // Update the connectivity button text
    $('#btnSfConnect', a4.parent().document).val('Connected');
}

function getInstanceType(instanceTypeId) {
    var instanceType;
    switch (instanceTypeId) {
        case 1:
            instanceType = 'Production';
            break;
        case 2:
            instanceType = 'Sandbox';
            break;
        default:
            instanceType = 'Sandbox';
            break;
    }

    return instanceType;
}

function resetStatusToDisconnect() {
    var params = {};
    var url = a4.getAction("ResetSfIntegrationStatusToDisconnected", "Integrations", "Settings");

    a4.callServerMethod(url, params, function (response) {
        if (response != undefined && response != null) {
            displayDisConnectivityDetails();
        }
    }, function (response) {
        a4.showErrorMessage(errorResources.SF_Integration_Error_Resetting_Status);
    });
}

$('.sf-accountType', '.sf-accountType-selection-div').on("click", function () {
    sfIntegrationDetails.sfInstanceTypeId = $(this).attr('data-id');
    $(this).addClass('selection-border');

    let otherAccountType = $(this).siblings('.sf-accountType');
    otherAccountType.removeClass('selection-border');
});

$('#btnSfConnectNext').on("click", function () {

    if (sfIntegrationDetails.sfInstanceTypeId === "0") {
        a4.showErrorMessage(errorResources.SF_Integration_Error_AccountType_Selection_Required);
        return;
    }

    checkForIntegrationStatusAfterProcessStarted();
    initiateSfIntegration();
});